<?php
require_once 'config.php';

$conn = connectDB();
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        // Get transactions with optional filters
        $startDate = isset($_GET['start_date']) ? $_GET['start_date'] : null;
        $endDate = isset($_GET['end_date']) ? $_GET['end_date'] : null;
        $type = isset($_GET['type']) ? $_GET['type'] : null;
        $studentId = isset($_GET['student_id']) ? (int)$_GET['student_id'] : null;
        $classId = isset($_GET['class_id']) ? (int)$_GET['class_id'] : null;

        $sql = "SELECT * FROM transactions WHERE 1=1";
        $params = [];
        $types = "";

        if ($startDate) {
            $sql .= " AND DATE(date) >= ?";
            $params[] = (string)$startDate;
            $types .= "s";
        }

        if ($endDate) {
            $sql .= " AND DATE(date) <= ?";
            $params[] = (string)$endDate;
            $types .= "s";
        }

        if ($type) {
            $sql .= " AND type = ?";
            $params[] = $type;
            $types .= "s";
        }

        if ($studentId) {
            $sql .= " AND student_id = ?";
            $params[] = $studentId;
            $types .= "i";
        }

        if ($classId) {
            $sql .= " AND class_id = ?";
            $params[] = $classId;
            $types .= "i";
        }

        $sql .= " ORDER BY date DESC";
        $stmt = $conn->prepare($sql);
        if (!empty($params)) {
            $stmt->bind_param($types, ...$params);
        }
        $stmt->execute();
        $result = $stmt->get_result();
        $transactions = $result->fetch_all(MYSQLI_ASSOC);

        returnResponse($transactions);
        break;

    case 'POST':
        // Add a new transaction
        $data = getRequestBody();

        // Validate required fields
        if (!isset($data['amount']) || !isset($data['type'])) {
            returnError("Amount and type are required", 400);
        }

        if (!in_array($data['type'], ['income', 'expense'])) {
            returnError("Type must be 'income' or 'expense'", 400);
        }

        // Create transaction
        $sql = "INSERT INTO transactions (student_id, class_id, amount, type, date, note) VALUES (?, ?, ?, ?, ?, ?)";
        $studentId = isset($data['student_id']) ? $data['student_id'] : null;
        $classId = isset($data['class_id']) ? $data['class_id'] : null;
        //$date = isset($data['date']) ? (string)date('Y-m-d H:i:s', strtotime($data['date'])) : (string)date('Y-m-d H:i:s');
        $date = $data['date'];
        $stmt = $conn->prepare($sql);
        $amount = isset($data['amount']) ? (float)$data['amount'] : 0;
        $type = isset($data['type']) ? (string)$data['type'] : '';
        $note = isset($data['note']) ? (string)$data['note'] : '';

        $stmt->bind_param(
            "iidsss",
            $studentId,
            $classId,
            $amount,
            $type,
            $date,
            $note
        );

        if (!$stmt->execute()) {
            returnError("Failed to add transaction: " . $conn->error);
        }

        $id = $conn->insert_id;

        // Return the new transaction
        $stmt = $conn->prepare("SELECT * FROM transactions WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $transaction = $result->fetch_assoc();

        returnResponse($transaction, 201);
        break;

    case 'PUT':
        // Update a transaction
        $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
        if (!$id) {
            returnError("Transaction ID is required", 400);
        }

        $data = getRequestBody();

        // Check if transaction exists
        $stmt = $conn->prepare("SELECT id FROM transactions WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows === 0) {
            returnError("Transaction not found", 404);
        }

        // Build update query
        $sql = "UPDATE transactions SET";
        $params = [];
        $types = "";
        $updates = [];

        if (isset($data['amount'])) {
            $updates[] = " amount = ?";
            $params[] = $data['amount'];
            $types .= "d";
        }

        if (isset($data['type']) && in_array($data['type'], ['income', 'expense'])) {
            $updates[] = " type = ?";
            $params[] = $data['type'];
            $types .= "s";
        }

        if (isset($data['date'])) {
            $updates[] = " date = ?";
            $params[] = (string)date('Y-m-d H:i:s', strtotime($data['date']));
            $types .= "s";
        }

        if (isset($data['note'])) {
            $updates[] = " note = ?";
            $params[] = $data['note'];
            $types .= "s";
        }

        if (isset($data['student_id'])) {
            $updates[] = " student_id = ?";
            $params[] = $data['student_id'];
            $types .= "i";
        }

        if (isset($data['class_id'])) {
            $updates[] = " class_id = ?";
            $params[] = $data['class_id'];
            $types .= "i";
        }

        if (empty($updates)) {
            returnError("No fields to update", 400);
        }

        $sql .= implode(",", $updates);
        $sql .= " WHERE id = ?";
        $params[] = $id;
        $types .= "i";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param($types, ...$params);
        if (!$stmt->execute()) {
            returnError("Failed to update transaction: " . $conn->error);
        }

        // Return the updated transaction
        $stmt = $conn->prepare("SELECT * FROM transactions WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $transaction = $result->fetch_assoc();

        returnResponse($transaction);
        break;

    case 'DELETE':
        // Delete a transaction
        $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
        if (!$id) {
            returnError("Transaction ID is required", 400);
        }

        // Check if transaction exists
        $stmt = $conn->prepare("SELECT id FROM transactions WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows === 0) {
            returnError("Transaction not found", 404);
        }

        // Delete transaction
        $stmt = $conn->prepare("DELETE FROM transactions WHERE id = ?");
        $stmt->bind_param("i", $id);
        if (!$stmt->execute()) {
            returnError("Failed to delete transaction: " . $conn->error);
        }

        returnResponse(['message' => 'Transaction deleted successfully']);
        break;

    default:
        returnError('Method not allowed', 405);
}

$conn->close();
?>