<?php
require_once 'config.php';

$conn = connectDB();
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        // Get all students or a specific student by ID
        $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
        
        if ($id) {
            $stmt = $conn->prepare("SELECT * FROM students WHERE id = ?");
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $result = $stmt->get_result();
            $student = $result->fetch_assoc();
            
            if (!$student) {
                returnError("Student not found", 404);
            }
            
            returnResponse($student);
        } else {
            // Get all students with optional search
            $search = isset($_GET['search']) ? $_GET['search'] : '';
            
            if ($search) {
                $searchTerm = "%$search%";
                $stmt = $conn->prepare("SELECT * FROM students WHERE name LIKE ? OR phone LIKE ? OR email LIKE ? ORDER BY name");
                $stmt->bind_param("sss", $searchTerm, $searchTerm, $searchTerm);
            } else {
                $stmt = $conn->prepare("SELECT * FROM students ORDER BY name");
            }
            
            $stmt->execute();
            $result = $stmt->get_result();
            $students = $result->fetch_all(MYSQLI_ASSOC);
            
            returnResponse($students);
        }
        break;
        
    case 'POST':
        // Add a new student
        $data = getRequestBody();
        
        if (!isset($data['name']) || !isset($data['phone'])) {
            returnError("Name and phone are required", 400);
        }
    
    // Lệnh cũ
    /*
        $stmt = $conn->prepare("INSERT INTO students (name, phone, email, school, address, note) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssss", 
            $data['name'], 
            $data['phone'], 
            $data['email'] ?? '', 
            $data['school'] ?? '', 
            $data['address'] ?? '', 
            $data['note'] ?? ''
        );
        */
        
        // Chuẩn bị câu lệnh INSERT cho bảng students
$stmt = $conn->prepare("INSERT INTO students (name, phone, email, school, address, note) VALUES (?, ?, ?, ?, ?, ?)");

// Kiểm tra nếu prepare thất bại thì dừng và thông báo lỗi
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}

// Gán dữ liệu và xử lý giá trị mặc định nếu không tồn tại
$name = $data['name'] ?? '';
$phone = $data['phone'] ?? '';
$email = $data['email'] ?? '';
$school = $data['school'] ?? '';
$address = $data['address'] ?? '';
$note = $data['note'] ?? '';

// Bind tham số với kiểu dữ liệu string (s)
$stmt->bind_param(
    "ssssss",
    $name,
    $phone,
    $email,
    $school,
    $address,
    $note
);
        
        if (!$stmt->execute()) {
            returnError("Failed to add student: " . $conn->error);
        }
        
        $id = $conn->insert_id;
        
        // Return the newly created student
        $stmt = $conn->prepare("SELECT * FROM students WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $student = $result->fetch_assoc();
        
        returnResponse($student, 201);
        break;
        
    case 'PUT':
        // Update an existing student
        $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
        
        if (!$id) {
            returnError("Student ID is required", 400);
        }
        
        $data = getRequestBody();
        
        // Check if student exists
        $stmt = $conn->prepare("SELECT id FROM students WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 0) {
            returnError("Student not found", 404);
        }
        
        // Update student
// Chuẩn bị truy vấn
$stmt = $conn->prepare(
    "UPDATE students SET name = ?, phone = ?, email = ?, school = ?, address = ?, note = ? WHERE id = ?"
);

if (!$stmt) {
    throw new Exception("Lỗi prepare statement: " . $conn->error);
}

$stmt->bind_param(
    "ssssssi",
    $data['name'],
    $data['phone'],
    $data['email'],
    $data['school'],
    $data['address'],
    $data['note'],
    $id
);
        
        if (!$stmt->execute()) {
            returnError("Failed to update student: " . $conn->error);
        }
        
        // Return the updated student
        $stmt = $conn->prepare("SELECT * FROM students WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $student = $result->fetch_assoc();
        
        returnResponse($student);
        break;
        
    case 'DELETE':
        // Delete a student
        $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
        
        if (!$id) {
            returnError("Student ID is required", 400);
        }
        
        // Check if student exists
        $stmt = $conn->prepare("SELECT id FROM students WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 0) {
            returnError("Student not found", 404);
        }
        
        // Delete student
        $stmt = $conn->prepare("DELETE FROM students WHERE id = ?");
        $stmt->bind_param("i", $id);
        
        if (!$stmt->execute()) {
            returnError("Failed to delete student: " . $conn->error);
        }
        
        returnResponse(['message' => 'Student deleted successfully']);
        break;
        
    default:
        returnError('Method not allowed', 405);
}

$conn->close();
?>