<?php
require_once 'config.php';

// Only allow POST requests for database setup
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    returnError('Method not allowed', 405);
}

// Create database tables
function createTables() {
    $conn = connectDB();
    
    // SQL statements to create tables
    $tables = [
        // Students table
        "CREATE TABLE IF NOT EXISTS students (
            id INT AUTO_INCREMENT PRIMARY KEY,
            name VARCHAR(100) NOT NULL,
            phone VARCHAR(20) NOT NULL,
            email VARCHAR(100),
            school VARCHAR(255),
            address TEXT,
            note TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )",
        
        // Classes table
        "CREATE TABLE IF NOT EXISTS classes (
            id INT AUTO_INCREMENT PRIMARY KEY,
            name VARCHAR(100) NOT NULL,
            type VARCHAR(50) NOT NULL,
            teacher VARCHAR(100) NOT NULL,
            schedule VARCHAR(50) NOT NULL,
            time_slot VARCHAR(50) NOT NULL,
            sessions INT NOT NULL,
            fee DECIMAL(20,0) NOT NULL,
            start_date DATE NOT NULL,
            status VARCHAR(20) NOT NULL,
            note TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )",
        
        // Enrollments table
        "CREATE TABLE IF NOT EXISTS enrollments (
            id INT AUTO_INCREMENT PRIMARY KEY,
            student_id INT NOT NULL,
            class_id INT NOT NULL,
            fee DECIMAL(20,0) NOT NULL,
            note TEXT,
            online BOOLEAN DEFAULT FALSE,
            transfer BOOLEAN DEFAULT FALSE,
            enroll_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            is_active BOOLEAN DEFAULT TRUE,
            status VARCHAR(20) DEFAULT 'chưa học',
            FOREIGN KEY (student_id) REFERENCES students(id) ON DELETE CASCADE,
            FOREIGN KEY (class_id) REFERENCES classes(id) ON DELETE CASCADE
        )",
        
        // Attendances table
        "CREATE TABLE IF NOT EXISTS attendances (
            id INT AUTO_INCREMENT PRIMARY KEY,
            student_id INT NOT NULL,
            class_id INT NOT NULL,
            date TIMESTAMP NOT NULL,
            is_present BOOLEAN DEFAULT TRUE,
            FOREIGN KEY (student_id) REFERENCES students(id) ON DELETE CASCADE,
            FOREIGN KEY (class_id) REFERENCES classes(id) ON DELETE CASCADE
        )",
        
        // Reservations table
        "CREATE TABLE IF NOT EXISTS reservations (
            id INT AUTO_INCREMENT PRIMARY KEY,
            student_id INT NOT NULL,
            class_id INT NOT NULL,
            reserve_fee DECIMAL(20,0) NOT NULL,
            sessions_attended INT NOT NULL,
            note TEXT,
            reserve_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (student_id) REFERENCES students(id) ON DELETE CASCADE,
            FOREIGN KEY (class_id) REFERENCES classes(id) ON DELETE CASCADE
        )",
        
        // Tasks table
        "CREATE TABLE IF NOT EXISTS tasks (
            id INT AUTO_INCREMENT PRIMARY KEY,
            name VARCHAR(255) NOT NULL,
            content TEXT NOT NULL,
            date DATE NOT NULL,
            note TEXT,
            completed BOOLEAN DEFAULT FALSE,
            priority VARCHAR(20) DEFAULT 'Trung bình',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )",
        
        // Transactions table
        "CREATE TABLE IF NOT EXISTS transactions (
            id INT AUTO_INCREMENT PRIMARY KEY,
            student_id INT NULL,
            class_id INT NULL,
            amount DECIMAL(20,0) NOT NULL,
            type ENUM('income','expense') NOT NULL,
            date TIMESTAMP NOT NULL,
            note TEXT,
            FOREIGN KEY (student_id) REFERENCES students(id) ON DELETE SET NULL,
            FOREIGN KEY (class_id) REFERENCES classes(id) ON DELETE SET NULL
        )",
        
        // Users table
        "CREATE TABLE IF NOT EXISTS users (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(100) NOT NULL UNIQUE,
            password VARCHAR(255) NOT NULL,
            name VARCHAR(100) NOT NULL,
            role ENUM('admin','user') NOT NULL DEFAULT 'user',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )",
        
        // User logs table
        "CREATE TABLE IF NOT EXISTS user_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            action VARCHAR(100) NOT NULL,
            details TEXT,
            timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
        )"
    ];
    
    // Create each table
    $errors = [];
    foreach ($tables as $sql) {
        if (!$conn->query($sql)) {
            $errors[] = $conn->error;
        }
    }
    
    // Create default admin user if not exists
    $password = password_hash('admin@123', PASSWORD_DEFAULT);
    $checkUserSql = "SELECT id FROM users WHERE username='admin@123'";
    $result = $conn->query($checkUserSql);
    
    if ($result->num_rows === 0) {
        $createAdminSql = "INSERT INTO users (username, password, name, role) VALUES ('admin@123', '$password', 'Administrator', 'admin')";
        if (!$conn->query($createAdminSql)) {
            $errors[] = "Failed to create admin user: " . $conn->error;
        }
        
        // Also create a regular user
        $userPassword = password_hash('user@123', PASSWORD_DEFAULT);
        $createUserSql = "INSERT INTO users (username, password, name, role) VALUES ('user@123', '$userPassword', 'User', 'user')";
        if (!$conn->query($createUserSql)) {
            $errors[] = "Failed to create regular user: " . $conn->error;
        }
    }
    

    
    $conn->close();
    
    if (!empty($errors)) {
        return ['success' => false, 'errors' => $errors];
    }
    
    return ['success' => true, 'message' => 'Database tables created successfully'];
}

// Execute table creation
$result = createTables();
returnResponse($result);
?>