<?php
require_once 'config.php';

// Simple routing system
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = explode('/', $uri);

// Find the API endpoint
$endpoint = null;
foreach ($uri as $segment) {
    if ($segment === 'api') {
        $endpoint = next($uri);
        break;
    }
}

// Route the request to the appropriate handler
switch ($endpoint) {
    case 'students':
        require_once 'students.php';
        break;
    case 'classes':
        require_once 'classes.php';
        break;
    case 'enrollments':
        require_once 'enrollments.php';
        break;
    case 'attendances':
        require_once 'attendances.php';
        break;
    case 'reservations':
        require_once 'reservations.php';
        break;
    case 'tasks':
        require_once 'tasks.php';
        break;
    case 'transactions':
        require_once 'transactions.php';
        break;
    case 'users':
        require_once 'users.php';
        break;
    case 'setup':
        require_once 'setup.php';
        break;
    default:
        returnError('Endpoint not found', 404);
}
?>