<?php
require_once 'config.php';
$conn = connectDB();
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
  case 'GET':
    // Get attendances with optional filters
    $studentId = isset($_GET['student_id']) ? (int)$_GET['student_id'] : null;
    $classId = isset($_GET['class_id']) ? (int)$_GET['class_id'] : null;
    $date = isset($_GET['date']) ? $_GET['date'] : null;

    $sql = "SELECT * FROM attendances WHERE 1=1";
    $params = [];
    $types = "";

    if ($studentId) {
      $sql .= " AND student_id=?";
      $params[] = $studentId;
      $types .= "i";
    }

    if ($classId) {
      $sql .= " AND class_id=?";
      $params[] = $classId;
      $types .= "i";
    }

    if ($date) {
      // Ensure date is treated as string
      $sql .= " AND DATE(date)=?";
      $params[] = (string)$date;
      $types .= "s";
    }

    $sql .= " ORDER BY date DESC limit 100000";
    $stmt = $conn->prepare($sql);
    
    if (!empty($params)) {
      $stmt->bind_param($types, ...$params);
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    $attendances = $result->fetch_all(MYSQLI_ASSOC);
    
    returnResponse($attendances);
    break;

  case 'POST':
    // Add a new attendance record
    $data = getRequestBody();

    // Validate required fields
    if (!isset($data['student_id']) || !isset($data['class_id']) || !isset($data['is_present'])) {
      returnError("student_id, class_id, and is_present are required", 400);
    }

    // Check if student and class exist
    $stmt = $conn->prepare("SELECT id FROM students WHERE id=?");
    $stmt->bind_param("i", $data['student_id']);
    $stmt->execute();
    
    if ($stmt->get_result()->num_rows === 0) {
      returnError("Student not found", 404);
    }

    $stmt = $conn->prepare("SELECT id FROM classes WHERE id=?");
    $stmt->bind_param("i", $data['class_id']);
    $stmt->execute();
    
    if ($stmt->get_result()->num_rows === 0) {
      returnError("Class not found", 404);
    }

    // Check if there's already an attendance record for this student, class, and date
    $date = isset($data['date']) ? (string)date('Y-m-d', strtotime($data['date'])) : (string)date('Y-m-d');
    //echo $date;
    $stmt = $conn->prepare("SELECT id FROM attendances WHERE student_id=? AND class_id=? AND DATE(date)=?");
    $stmt->bind_param("iis", $data['student_id'], $data['class_id'], $date);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
      // Update existing attendance
      $existingId = $result->fetch_assoc()['id'];
      $now = (string)date('Y-m-d H:i:s');
      echo $existingId;
      $stmt = $conn->prepare("UPDATE attendances SET is_present=?, date=? WHERE id=?");
      $isPresent = $data['is_present'] ? 1 : 0;
      $stmt->bind_param("isi", $isPresent,  $data['date'], $existingId);
      
      if (!$stmt->execute()) {
        returnError("Failed to update attendance: " . $conn->error);
      }

      // Return the updated attendance
      $stmt = $conn->prepare("SELECT * FROM attendances WHERE id=?");
      $stmt->bind_param("i", $existingId);
      $stmt->execute();
      $result = $stmt->get_result();
      $attendance = $result->fetch_assoc();
      
      returnResponse($attendance);
    } else {
      // Create new attendance record
      //$now = (string)date('Y-m-d H:i:s');
      
      $stmt = $conn->prepare("INSERT INTO attendances (student_id, class_id, date, is_present) VALUES (?, ?, ?, ?)");
      $isPresent = $data['is_present'] ? 1 : 0;
      $stmt->bind_param("iisi", $data['student_id'], $data['class_id'], $data['date'], $isPresent);
      
      if (!$stmt->execute()) {
        returnError("Failed to add attendance: " . $conn->error);
      }

      $id = $conn->insert_id;

      // Return the newly created attendance
      $stmt = $conn->prepare("SELECT * FROM attendances WHERE id=?");
      $stmt->bind_param("i", $id);
      $stmt->execute();
      $result = $stmt->get_result();
      $attendance = $result->fetch_assoc();
      
      returnResponse($attendance, 201);
    }
    break;

  case 'PUT':
    // Update an attendance record
    $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
    
    if (!$id) {
      returnError("Attendance ID is required", 400);
    }
    
    $data = getRequestBody();

    // Check if attendance exists
    $stmt = $conn->prepare("SELECT id FROM attendances WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
      returnError("Attendance record not found", 404);
    }

    // Update attendance
    $now = (string)date('Y-m-d H:i:s');
    $stmt = $conn->prepare("UPDATE attendances SET is_present=?, date=? WHERE id=?");
    $isPresent = $data['is_present'] ? 1 : 0;
    $stmt->bind_param("isi", $isPresent, $now, $id);
    
    if (!$stmt->execute()) {
      returnError("Failed to update attendance: " . $conn->error);
    }

    // Return the updated attendance
    $stmt = $conn->prepare("SELECT * FROM attendances WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $attendance = $result->fetch_assoc();
    
    returnResponse($attendance);
    break;

  case 'DELETE':
    // Delete an attendance record
    $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
    
    if (!$id) {
      returnError("Attendance ID is required", 400);
    }

    // Check if attendance exists
    $stmt = $conn->prepare("SELECT id FROM attendances WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
      returnError("Attendance record not found", 404);
    }

    // Delete attendance
    $stmt = $conn->prepare("DELETE FROM attendances WHERE id=?");
    $stmt->bind_param("i", $id);
    
    if (!$stmt->execute()) {
      returnError("Failed to delete attendance: " . $conn->error);
    }
    
    returnResponse(['message' => 'Attendance record deleted successfully']);
    break;

  default:
    returnError('Method not allowed', 405);
}

$conn->close();
?>